/*
 * Copyright: 2018 WERK II GmbH, Germany [www.priint.com].
 * 
 * WERK II permits you to use this file in accordance with the terms of the WERK II license agreement
 * accompanying it. If you have received this file from a source other than WERK II, then your use
 * of it requires the prior written permission of WERK II.
 *  
 * Contact info@priint.com if you have any questions regarding the license.
 * 
 */
package com.priint.pubserver.auth.realm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * 
 * Example user list document
 * 
 * <pre>
 *  &lt;users&gt;
 *   &lt;user name="Elsa" password="****" email="elsa.demorealm@werk-ii.com"&gt;
 *   	&lt;group&gt;Grommits&lt;/group&gt;
 *   	&lt;group&gt;Struppies&lt;/group&gt;
 *   &lt;/user&gt; 
 *   &lt;user name="John" password="****" email="john.demorealm@werk-ii.com"&gt;
 *   	&lt;group&gt;Tims&lt;/group&gt;
 *   	&lt;group&gt;Struppies&lt;/group&gt;
 *   &lt;/user&gt; 
 *  &lt;/users&gt;
 * </pre>
 * <p>
 * This expects some mapping in shiro.ini between external groups (here Grommits, Struppies, Tims) and pubserver groups.
 */
@XmlRootElement(name = "users", namespace = "")
public class DemoUsers implements Serializable {

	private static final long serialVersionUID = -9018687526492082051L;

	@XmlElement(name = "user")
	private List<DemoUser> users;

	public List<DemoUser> getUsers() {
		if (users == null) {
			users = new ArrayList<>();
		}
		return users;
	}

	public static class DemoUser implements Serializable {

		private static final long serialVersionUID = -8018687526492082051L;

		@XmlAttribute
		private String username;

		@XmlAttribute
		private String email;

		@XmlAttribute
		private String password;

		@XmlElement(name = "group")
		private List<String> groups;

		public String getUsername() {
			return username;
		}

		public String getEmail() {
			return email;
		}

		public String getPassword() {
			return password;
		}

		public List<String> getGroups() {
			return groups;
		}

	}

}