/*
 * Copyright: 2018 WERK II GmbH, Germany [www.priint.com].
 * 
 * WERK II permits you to use this file in accordance with the terms of the WERK II license agreement
 * accompanying it. If you have received this file from a source other than WERK II, then your use
 * of it requires the prior written permission of WERK II.
 *  
 * Contact info@priint.com if you have any questions regarding the license.
 * 
 */
package com.priint.pubserver.auth.realm;

/**
 * Configuration object for {@link DemoRealm}.
 * <p>
 * This is derived from {@link AbstractRealmConfig} which provides all fields necessary for typical mapping into pubserver user management.
 * 
 * <p>
 * Example - to be placed into shiro.ini
 * 
 * <pre>
 * [main]
 * demoRealm = com.priint.pubserver.auth.realm.DemoRealm
 * demoRealm.config.url = file:///C:/devstack/workspace/demos/DemoRealm/example-users.xml
 * demoRealm.config.defaultRole = Normal User
 * demoRealm.config.defaultMenu = publications
 * demoRealm.config.defaultDataset = demo
 * demoRealm.config.membershipMapping = Tims:Administrator,Struppies:DTP-Operator
 * demoRealm.config.includePattern = ^.+@werk-ii\.com$
 * demoRealm.config.excludePattern = ^.+@priint\.com$
 * </pre>
 * 
 * Mandatory
 * <ul>
 * <li>url
 * <li>defaultRole
 * <li>defaultMenu
 * <li>defaultDataset
 * <li>membershipMapping
 * </ul>
 * 
 * Optional 
 * <ul>
 * <li>includePattern
 * <li>excludePattern
 * </ul>
 * 
 * <p>
 * This example maps external roles "Tims" and "Struppies" to pubserver roles "Administrator" and "DTP-Operator". "Administrator" is a
 * built-in role in pubserver. "DTP-Operator" is supposed to be a custom role.
 * <p>
 * The external group "Grommits" - as used in the DemoUsers example - is not mapped here. So, it will be ignored for pubserver.
 * 
 */
public class DemoConfig extends AbstractRealmConfig {

	private String url;

	public DemoConfig() {
		super();
	}

	public String getUrl() {
		return url;
	}

	@Override
	public String toString() {
		return "DemoConfig [url=" + url + ", name=" + getName() + ", membershipMapping=" + getMembershipMapping() + ", defaultDataset="
				+ getDefaultDataset() + ", defaultMenu=" + getDefaultMenu() + ", defaultRole=" + getDefaultRole() + ", includePattern="
				+ getIncludePattern() + ", excludePattern=" + getExcludePattern() + "]";
	}

}